package com.ediagnosis.cdr.dashBoard;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class DashBoardTest {

    public static void main(String[] args) throws Exception {
        System.out.println("top -bn1");
        getCpuUsage();
        System.out.println("free -h");
        getMemoryUsage();
        System.out.println("df -h /");
        getDiskUsage();
        System.out.println("cat /proc/loadavg");
        getLoadAverage();

    }

    public static void getCpuUsage() throws Exception {
        ProcessBuilder pb = new ProcessBuilder("top", "-bn1");
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.contains("Cpu(s)")) {
                System.out.println(line);
            }
        }
    }

    public static void getMemoryUsage() throws Exception {
        ProcessBuilder pb = new ProcessBuilder("free", "-h");
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("Mem:")) {
                System.out.println(line);
            }
        }
    }


    public static void getDiskUsage() throws Exception {
        ProcessBuilder pb = new ProcessBuilder("df", "-h", "/");
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line;
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
    }


    public static void getLoadAverage() throws Exception {
        ProcessBuilder pb = new ProcessBuilder("cat", "/proc/loadavg");
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line;
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
        System.out.println("cpu cores:"+ Runtime.getRuntime().availableProcessors());
    }



}
