package com.ediagnosis.cdr.dashBoard.hostMonitor;

import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Optional;

@Component
public class HostMonitorValueRepository {


    //    todo: 待扩展，获取集群主机的列表
    public HostMonitorValue.HostValue getHostValue() {
        Optional<Map<String, String>> hostIpAndNameOptional = HostMonitor.getHostIpAndName();
        String hostname = "";
        String ip = "";
        if (hostIpAndNameOptional.isPresent()) {
            Map<String, String> hostMap = hostIpAndNameOptional.get();
            hostname = hostMap.get("hostname");
            ip = hostMap.get("ip");
        }


        return new HostMonitorValue.HostValue(hostname, ip);
    }

    //    todo: 带扩展，获取指定主机的监控信息
    public HostMonitorValue getHostMonitorValue(String hostName) {

        Optional<Map<String, String>> hostIpAndNameOptional = HostMonitor.getHostIpAndName();
        HostMonitorValue.HostValue hostValue;

        if (hostIpAndNameOptional.isPresent()) {
            Map<String, String> hostMap = hostIpAndNameOptional.get();
            String hostNameInner = hostMap.get("hostname");
            String ip = hostMap.get("ip");
            hostValue = new HostMonitorValue.HostValue(hostNameInner, ip);
        }else {
            hostValue = new HostMonitorValue.HostValue("", "");
        }


        Optional<Map<String, String>> cpuUsageOptional = HostMonitor.getCpuUsage();
        HostMonitorValue.CpuValue cpuValue;
        if (cpuUsageOptional.isPresent()) {
            Map<String, String> cpuMap = cpuUsageOptional.get();
            String cpuUsage = cpuMap.get("cpuUsage");
            String cpuCores = cpuMap.get("cpuCores");
            int cpuCoresNum = Integer.parseInt(cpuCores);
            String loadAverage = cpuMap.get("loadAverage");
            double loadAverageNum = Double.parseDouble(loadAverage);
            cpuValue = new HostMonitorValue.CpuValue(cpuCoresNum, loadAverageNum, cpuUsage);
        } else {
            cpuValue = new HostMonitorValue.CpuValue(0, 0, "");
        }
        Optional<Map<String, String>> memoryUsageOptional = HostMonitor.getMemoryUsage();
        HostMonitorValue.MemoryValue memoryValue;
        if (memoryUsageOptional.isPresent()) {
            Map<String, String> memoryMap = memoryUsageOptional.get();
            String used = memoryMap.get("used");
            String size = memoryMap.get("size");
            String free = memoryMap.get("free");
            String memoryUsage = memoryMap.get("memoryUsage");
            memoryValue = new HostMonitorValue.MemoryValue(memoryUsage, size, used, free);
        } else {
            memoryValue = new HostMonitorValue.MemoryValue("", "", "", "");
        }

        Optional<Map<String, String>> diskUsageOptional = HostMonitor.getDiskUsage();
        HostMonitorValue.DiskValue diskValue;
        if (diskUsageOptional.isPresent()) {

            Map<String, String> diskMap = diskUsageOptional.get();
            String usePercent = diskMap.get("usePercent");
            String used = diskMap.get("used");
            String size = diskMap.get("size");
            String free = diskMap.get("free");
            diskValue = new HostMonitorValue.DiskValue(usePercent, size, used, free);
        } else {
            diskValue = new HostMonitorValue.DiskValue("", "", "", "");
        }

        return new HostMonitorValue(hostValue, cpuValue, memoryValue, diskValue);
    }

}
