package com.ediagnosis.cdr.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Component
@Order(1)
public class CaffeineCacheExecutor implements CacheExecutor {


    private static final Logger log = LoggerFactory.getLogger(CaffeineCacheExecutor.class);
    private final Cache<String, Object> cache;

    public CaffeineCacheExecutor() {
        this.cache = Caffeine.newBuilder()
                .expireAfterWrite(3, TimeUnit.MINUTES)
                .maximumSize(10_000)
                .build();
    }


    @Override
    public void put(String key, Object value) {
        log.info("put cache key:{}", key);
        cache.put(key, value);

    }

    @Override
    public <T> Optional<T> get(String key, Class<T> clazz) {
        Object object = cache.getIfPresent(key);
        if (object != null) {
            if (clazz.isInstance(object)) {
                return Optional.of(clazz.cast(object));
            } else {
                // 类型不匹配，可以记录警告或直接返回 empty
                log.warn("Cached object type mismatch for key '{}': expected {}, got {}",
                        key, clazz.getName(), object.getClass().getName());
                return Optional.empty();
            }
        }
        log.warn("Cache miss for key '{}'", key);
        return Optional.empty();
    }
}
