package com.ediagnosis.cdr.dashBoard;

import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

@SpringBootTest
public class AsyncTest {


    @Test
    public void test() throws ExecutionException, InterruptedException {


        List<Future<Integer>> futures = new ArrayList<>(5);
        try (ExecutorService executorService = Executors.newFixedThreadPool(10)) {
           for (int j=1;j<6;j++) {
               int finalJ = j;
               Future<Integer> future = executorService.submit(() -> {
                   System.out.println(LocalDateTime.now()+" task " + finalJ + " submit from " + Thread.currentThread().getName());

                   try {
                       Thread.sleep(1000L * finalJ);
                   } catch (InterruptedException e) {
                       throw new RuntimeException(e);
                   }


                   return finalJ;
               });
               futures.add(future);
           }


            for (int j=0;j<5;j++) {
                Future<Integer> future = futures.get(j);
                Integer integer = future.get();
                System.out.println(LocalDateTime.now()+" task " + integer+ " complete from " + Thread.currentThread().getName());
            }
        }

    }
}
