package com.ediagnosis.cdr.dao;

import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.row.Row;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.util.Assert;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ExtendWith(SpringExtension.class)
@SpringBootTest
public class DwsRepositoryTest {


    @Autowired
    HiveQueryExecutor hiveQueryExecutor;

    @Test
    public void queryPageWithSql() {
        String sql = """
                select p.patient_id,p.patient_name,r.patient_id,r.visit_no from ods.xjd_patient_info p, ods.xjd_emergency_record r
                        where p.patient_id=r.patient_id  and p.id='3';
                """;
        Page<Row> rowPage = hiveQueryExecutor.selectByFullSql(sql, 1, 10);
        System.out.println(rowPage);
        Assert.isTrue(rowPage.getRecords().size() <= 10, "数据量不符合");
        List<Map<String, String>> result = rowPage.getRecords().stream()
                .map(row -> {
                    Map<String, Object> camelKeysMap = row.toCamelKeysMap();
                    Map<String, String> flatMap = new HashMap<>();

                    camelKeysMap.forEach((table, value) -> {
                        if (value instanceof Map<?, ?> m) {
                            m.forEach((key, val) -> {
                                if (key instanceof String field && val instanceof String fieldValue) {
                                    flatMap.put(table + "." + field, fieldValue);
                                }
                            });
                        }
                    });

                    return flatMap;
                })
                .filter(map -> !map.isEmpty()) // 可选：过滤掉空 map
                .toList();
        System.out.println(result);
    }

}
