package com.ediagnosis.cdr.dataCollect.inner;

import com.ediagnosis.cdr.dataCollect.dao.BusinessDataDao;
import com.ediagnosis.cdr.dataCollect.dao.dto.BusinessDataTableDTO;
import com.ediagnosis.cdr.dataCollect.dao.dto.BusinessDataTableQueryDTO;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

/**
 * @author monojun
 * @description 数据表Repository
 * @createTime 2025年08月05日
 */
@Repository
@RequiredArgsConstructor
public class BusinessTableRepository {

    private final BusinessDataDao businessDataDao;

    /**
     * 新增源业务表
     *
     * @param dataTableDTO 源业务表dto
     * @return 源业务表主键id
     */
    public Long addDataTable(BusinessDataTableDTO dataTableDTO) {
        return businessDataDao.addDataTable(dataTableDTO);
    }


    /**
     * 更新源业务表
     *
     * @param dataTableDTO 业务表dto
     * @return 源业务表主键id
     */
    public Long updateDataTable(BusinessDataTableDTO dataTableDTO) {
        return businessDataDao.updateDataTable(dataTableDTO);
    }

    /**
     * 分页查询源业务表信息
     *
     * @param queryDTO 查询dto
     * @return PageInfo<BusinessDataSystem>
     */
    public Page<BusinessDataTableDTO> queryPage(BusinessDataTableQueryDTO queryDTO) {
        return businessDataDao.queryTablePage(queryDTO);
    }

    /**
     * 删除源业务表
     *
     * @param dataTableId 源数据表id
     */
    public void deleteDataSystem(Long dataTableId) {
        businessDataDao.deleteDataTable(dataTableId);
    }
}
