package com.ediagnosis.cdr.dataCollect.endpoint.param;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;

/**
 * @author monojun
 * @description 数据表更新参数
 * @createTime 2025年08月05日
 */
@Data
public class DataTableUpdateParam implements Serializable {
    @Serial
    private static final long serialVersionUID = 646168747509610187L;

    /**
     * 主键id
     */
    @Id(value = "id", keyType = KeyType.Auto)
    private Long id;

    /**
     * 业务表名称
     */
    @Column(value = "name")
    private String name;

    /**
     * 业务表编号
     */
    @Column(value = "table_no")
    private String tableNo;

    /**
     * 业务系统id
     */
    @Column(value = "business_id")
    private Long businessId;

    /**
     * 业务数据源id
     */
    @Column(value = "source_id")
    private Long sourceId;

    /**
     * 描述
     */
    @Column(value = "description")
    private String description;
}
