package com.ediagnosis.cdr.dataCollect.dao.dto;

import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;

/**
 * @author monojun
 * @description 数据源dto
 * @createTime 2025年07月31日
 */
@Data
public class BusinessDataSourceDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = -447329639545048136L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 数据源名称
     */
    private String name;

    /**
     * 数据源类型
     */
    private String type;

    /**
     * IP地址
     */
    private String ipAddress;

    /**
     * 属性信息
     */
    private String properties;

    /**
     * 业务系统id
     */
    private Long businessId;

    /**
     * 业务系统名称
     */
    private String businessName;

    /**
     * 描述
     */
    private String description;

    /**
     * 连接状态: 0-未知 1-已连接 2-未连接
     */
    private Integer status;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人
     */
    private Long createUserId;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private Long updateUserId;


}
