package com.ediagnosis.cdr.dataCollect;

import com.ediagnosis.cdr.dataCollect.dao.dto.BusinessDataSystemQueryDTO;
import com.ediagnosis.cdr.dataCollect.dao.dto.BusinessDataTableDTO;
import com.ediagnosis.cdr.dataCollect.dao.dto.BusinessDataTableQueryDTO;
import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataSystem;
import com.ediagnosis.cdr.dataCollect.endpoint.param.*;
import com.ediagnosis.cdr.dataCollect.endpoint.vo.BusinessDataSystemVo;
import com.ediagnosis.cdr.dataCollect.endpoint.vo.BusinessDataTableVo;
import com.ediagnosis.cdr.dataCollect.inner.BusinessTableRepository;
import com.ediagnosis.cdr.util.PageConvertUtils;
import com.ediagnosis.cdr.value.PageVo;
import com.ediagnosis.cdr.value.Response;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author monojun
 * @description 源数据表controller
 * @createTime 2025年08月05日
 */
@RestController
@RequestMapping("/dataTable")
@RequiredArgsConstructor
public class BusinessTableController {

    private final BusinessTableRepository tableRepository;

    @PostMapping("/add")
    public Response<Long> page(@RequestBody DataTableAddParam addParam) {
        BusinessDataTableDTO addDTO = new BusinessDataTableDTO();
        BeanUtils.copyProperties(addParam, addDTO);
        Long id = tableRepository.addDataTable(addDTO);
        return Response.success(id);
    }

    @PostMapping("/update")
    public Response<Long> update(@RequestBody DataTableUpdateParam updateParam) {
        BusinessDataTableDTO updateDTO = new BusinessDataTableDTO();
        BeanUtils.copyProperties(updateParam, updateDTO);
        Long id = tableRepository.updateDataTable(updateDTO);
        return Response.success(id);
    }


    @PostMapping("/page")
    public Response<PageVo<BusinessDataTableVo>> page(@RequestBody DataTableQueryParam queryParam) {
        BusinessDataTableQueryDTO queryDTO = new BusinessDataTableQueryDTO();
        BeanUtils.copyProperties(queryParam, queryDTO);
        Page<BusinessDataTableDTO> dataSystemPage = tableRepository.queryPage(queryDTO);
        PageVo<BusinessDataTableVo> systemVoPageInfo = PageConvertUtils.copyPageInfo(dataSystemPage, dataTableDTO -> {
            BusinessDataTableVo vo = new BusinessDataTableVo();
            BeanUtils.copyProperties(dataTableDTO, vo);
            return vo;
        });
        return Response.success(systemVoPageInfo);
    }


    @PostMapping("/delete")
    public Response<Long> delete(@RequestBody DataTableDeleteParam deleteParam) {
        tableRepository.deleteDataSystem(deleteParam.getId());
        return Response.success(deleteParam.getId());
    }
}
