package com.ediagnosis.cdr.value;


import java.io.Serializable;


public class Response<T> implements Serializable {

    private boolean status;
    private String msg;
    private T content;


    public Response(boolean status, String msg) {
        this.status = status;
        this.msg = msg;
    }

    public Response(boolean status, String msg, T content) {
        this.status = status;
        this.msg = msg;
        this.content = content;
    }



    public static <T> Response<T> success(T content) {
        return new Response<>(true, "", content);
    }

    public static <T> Response<T> success(String msg, T content) {
        return new Response<>(true, msg, content);
    }

    public static <T> Response<T> success(String msg) {
        return new Response<>(true, msg, null);
    }

    public static <T> Response<T> error(String msg, T defaultContent) {
        return new Response<>(false, msg, defaultContent);
    }

    public static <T> Response<T> error(String msg) {
        return new Response<>(false, msg, null);
    }

    public boolean isStatus() {
        return status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getContent() {
        return content;
    }

    public void setContent(T content) {
        this.content = content;
    }

}
