package com.ediagnosis.cdr.service.impl;

import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataTableField;
import com.ediagnosis.cdr.dataCollect.dao.mapper.BusinessDataTableFieldMapper;
import com.ediagnosis.cdr.model.dto.BusinessDataTableFieldQueryDTO;
import com.ediagnosis.cdr.service.BusinessDataTableFieldService;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * @author monojun
 * @description 业务表字段service
 * @createTime 2025年07月31日
 */
@Service
public class BusinessDataTableFieldServiceImpl implements BusinessDataTableFieldService {

    @Autowired
    private BusinessDataTableFieldMapper dataTableFieldMapper;

    @Override
    public Page<BusinessDataTableField> queryPage(BusinessDataTableFieldQueryDTO queryDTO) {
        QueryWrapper queryWrapper = QueryWrapper.create();
        if (StringUtils.hasText(queryDTO.getFieldName())) {
            queryWrapper.like(BusinessDataTableField::getFieldName, queryDTO.getFieldName());
        }
        if (StringUtils.hasText(queryDTO.getFieldType())) {
            queryWrapper.like(BusinessDataTableField::getFieldType, queryDTO.getFieldType());
        }
        if (queryDTO.getTableId() != null) {
            queryWrapper.eq(BusinessDataTableField::getTableId, queryDTO.getTableId());
        }
        queryWrapper.orderBy(BusinessDataTableField::getId, false);
        return dataTableFieldMapper.paginate(queryDTO.getPageNo(), queryDTO.getPageSize(), queryWrapper);
    }
}
