package com.ediagnosis.cdr.service.impl;

import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataSource;
import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataSystem;
import com.ediagnosis.cdr.dataCollect.dao.mapper.BusinessDataSourceMapper;
import com.ediagnosis.cdr.model.dto.BusinessDataSourceDTO;
import com.ediagnosis.cdr.model.dto.BusinessDataSourceQueryDTO;
import com.ediagnosis.cdr.service.BusinessDataSourceService;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryWrapper;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * @author monojun
 * @description 业务数据源service
 * @createTime 2025年07月31日
 */
@Service
public class BusinessDataSourceServiceImpl implements BusinessDataSourceService {

    @Autowired
    private BusinessDataSourceMapper dataSourceMapper;

    @Override
    public Page<BusinessDataSourceDTO> queryPage(BusinessDataSourceQueryDTO queryDTO) {
        QueryWrapper queryWrapper = QueryWrapper.create()
                .select("d.*", "ds.name as businessName")
                .from(BusinessDataSource.class).as("d")
                .leftJoin(BusinessDataSystem.class).as("ds")
                .on(BusinessDataSource::getBusinessId, BusinessDataSystem::getId)
                .orderBy(BusinessDataSource::getId, false);
        if (!CollectionUtils.isEmpty(queryDTO.getBusinessIds())) {
            queryWrapper.in(BusinessDataSource::getBusinessId, queryDTO.getBusinessIds());
        }
        if (StringUtils.hasText(queryDTO.getName())) {
            queryWrapper.like(BusinessDataSource::getName, queryDTO.getName());
        }
        if (StringUtils.hasText(queryDTO.getIpAddress())) {
            queryWrapper.like(BusinessDataSource::getIpAddress, queryDTO.getIpAddress());
        }
        if (StringUtils.hasText(queryDTO.getType())) {
            queryWrapper.eq(BusinessDataSource::getType, queryDTO.getType());
        }
        if (queryDTO.getStatus() != null) {
            queryWrapper.eq(BusinessDataSource::getStatus, queryDTO.getStatus());
        }
        return dataSourceMapper.paginateAs(queryDTO.getPageNo(), queryDTO.getPageSize(), queryWrapper, BusinessDataSourceDTO.class);
    }
}
