package com.ediagnosis.cdr.model.param;

import lombok.Data;

import java.io.Serial;
import java.util.List;

/**
 * @author monojun
 * @description 数据源查询参数
 * @createTime 2025年07月31日
 */
@Data
public class BusinessDataSourceQueryParam extends PageQuery {
    @Serial
    private static final long serialVersionUID = 4384878864788101913L;

    /**
     * 业务系统id列表
     */
    private List<Long> businessIds;

    /**
     * 数据源名称
     */
    private String name;

    /**
     * ip地址
     */
    private String ipAddress;

    /**
     * 数据源类型
     */
    private String type;
}
