package com.ediagnosis.cdr.dataCollect.dao.entity;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.Table;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;

/**
 * @author monojun
 * @description 业务字段信息表
 * @createTime 2025年07月31日
 */
@Data
@Table(value = "business_data_table_field")
public class BusinessDataTableField implements Serializable {
    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @Id(value = "id", keyType = KeyType.Auto)
    private Long id;

    /**
     * 字段名称
     */
    @Column(value = "field_name")
    private String fieldName;

    /**
     * 字段类型
     */
    @Column(value = "field_type")
    private String fieldType;

    /**
     * 业务表id
     */
    @Column(value = "table_id")
    private Long tableId;

    /**
     * 描述
     */
    @Column(value = "description")
    private String description;

    /**
     * 创建时间
     */
    @Column(value = "create_time")
    private Date createTime;

    /**
     * 创建人
     */
    @Column(value = "create_user_id")
    private Long createUserId;

    /**
     * 更新时间
     */
    @Column(value = "update_time")
    private Date updateTime;

    /**
     * 更新人
     */
    @Column(value = "update_user_id")
    private Long updateUserId;

    /**
     * 是否删除: 0-未删除 1-已删除
     */
    @Column(value = "is_deleted", isLogicDelete = true)
    private Byte isDeleted;
}