package com.ediagnosis.cdr.dao;


import com.ediagnosis.cdr.value.PageVo;
import com.mybatisflex.core.row.Row;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class DwsRepository {


    private final HiveQueryExecutor hiveQueryExecutor;

    public DwsRepository(HiveQueryExecutor hiveQueryExecutor) {
        this.hiveQueryExecutor = hiveQueryExecutor;
    }

    public PageVo<Map<String, String>> queryPage(String sql, int pageNo, int pageSize) {
        com.mybatisflex.core.paginate.Page<Row> rowPage = hiveQueryExecutor.selectByFullSql(sql, pageNo, pageSize);
        List<Map<String, String>> result = rowPage.getRecords().stream()
                .map(row -> {
                    Map<String, Object> camelKeysMap = row.toCamelKeysMap();
                    Map<String, String> flatMap = new HashMap<>();

                    camelKeysMap.forEach((table, value) -> {
                        if (value instanceof Map<?, ?> m) {
                            m.forEach((key, val) -> {
                                if (key instanceof String field && val instanceof String fieldValue) {
                                    flatMap.put(table + "." + field, fieldValue);
                                }
                            });
                        }
                    });

                    return flatMap;
                })
                .filter(map -> !map.isEmpty()) // 可选：过滤掉空 map
                .toList();

        return new PageVo<>(pageNo, pageSize, rowPage.getTotalRow(), result);
    }



}
