package com.ediagnosis.cdr.controller;

import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataSystem;
import com.ediagnosis.cdr.model.dto.BusinessDataSystemQueryDTO;
import com.ediagnosis.cdr.model.param.BusinessDataSystemQueryParam;
import com.ediagnosis.cdr.model.vo.BusinessDataSystemVo;
import com.ediagnosis.cdr.service.BusinessDataSystemService;
import com.ediagnosis.cdr.util.PageConvertUtils;
import com.ediagnosis.cdr.value.Response;
import com.ediagnosis.cdr.value.PageVo;
import com.mybatisflex.core.paginate.Page;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author monojun
 * @description 业务系统接口
 * @createTime 2025年07月31日
 */
@RestController
@RequestMapping("/dataSystem")
public class BusinessDataSystemController {

    @Autowired
    private BusinessDataSystemService dataSystemService;

    @PostMapping("/page")
    public Response<PageVo<BusinessDataSystemVo>> page(@RequestBody BusinessDataSystemQueryParam queryParam) {
        BusinessDataSystemQueryDTO queryDTO = new BusinessDataSystemQueryDTO();
        BeanUtils.copyProperties(queryParam, queryDTO);
        Page<BusinessDataSystem> dataSystemPage = dataSystemService.queryPage(queryDTO);
        PageVo<BusinessDataSystemVo> systemVoPageInfo = PageConvertUtils.copyPageInfo(dataSystemPage, dataSystem -> {
            BusinessDataSystemVo vo = new BusinessDataSystemVo();
            BeanUtils.copyProperties(dataSystem, vo);
            return vo;
        });
        return Response.success(systemVoPageInfo);
    }
}
