package com.ediagnosis.cdr.controller;

import com.ediagnosis.cdr.model.dto.BusinessDataSourceDTO;
import com.ediagnosis.cdr.model.dto.BusinessDataSourceQueryDTO;
import com.ediagnosis.cdr.model.param.BusinessDataSourceQueryParam;
import com.ediagnosis.cdr.model.vo.BusinessDataSourceVo;
import com.ediagnosis.cdr.service.BusinessDataSourceService;
import com.ediagnosis.cdr.util.PageConvertUtils;
import com.ediagnosis.cdr.value.PageVo;
import com.ediagnosis.cdr.value.Response;
import com.mybatisflex.core.paginate.Page;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author monojun
 * @description 数据源接口
 * @createTime 2025年07月31日
 */
@RestController
@RequestMapping("/dataSource")
public class BusinessDataSourceController {

    @Autowired
    private BusinessDataSourceService dataSourceService;

    @PostMapping("/page")
    public Response<PageVo<BusinessDataSourceVo>> page(@RequestBody BusinessDataSourceQueryParam queryParam) {
        BusinessDataSourceQueryDTO queryDTO = new BusinessDataSourceQueryDTO();
        BeanUtils.copyProperties(queryParam, queryDTO);
        Page<BusinessDataSourceDTO> dataSourcePage = dataSourceService.queryPage(queryDTO);
        PageVo<BusinessDataSourceVo> systemVoPageInfo = PageConvertUtils.copyPageInfo(dataSourcePage, dataSourceDTO -> {
            BusinessDataSourceVo vo = new BusinessDataSourceVo();
            BeanUtils.copyProperties(dataSourceDTO, vo);
            vo.setBizSystemId(dataSourceDTO.getBusinessId());
            vo.setBizSystemName(dataSourceDTO.getBusinessName());
            return vo;
        });
        return Response.success(systemVoPageInfo);
    }
}
