/**
 * 分包原则：
 *         1、每层包结构代表一个特定领域，项目整体按照业务领域进行一级分包，简称业务模块，模块内按功能进行分包。
 *         2、每层第一层包目录下的类为公开类，额外追加的公开包需要再package-info.java中声明。
 *         3、每层包目录下的子包结构的类为私有类，私有类不提供外部访问，外部不感知。
 *         4、开发遵循测试先行的流程，每层领域都要有单元测试、集成测试。
 * 代码设计原则：
 *            1、注重扩展性的同时，要警惕过渡设计 。
 *            2、尽力遮蔽对特定框架、软件的强依赖，形成防腐层，便于重构。
 *            3、代码以简洁为目标，例如只有一个实现类的情况，没有必要使用接口。
 *            4、代码尽量使用抽象类、组合、继承等手段解构大类，形成一系列灵活的小类。
 *            5、如果不写注释，代码要做到语义化，仅通过阅读单词就能准确描述出代码的意图。
 * 角色语义：
 *     构建类：
 *         1、repository：代表提供某类对象的仓库，对对象的生命周期进行管理，外部直接询问repository拿到对象，不关注具体细节。
 *         2、builder：代表提供对象构建者，为对象的属性进行组装，用于构建复杂对象。
 *         3、factory：代表提供对象工厂，提供对象创建功能，用于构建消耗性对象。
 *     行为类：
 *         1、service：代表提供某类相关服务，代表一组难以归属实例对象的行为抽象。
 *         2、dao:数据访问对象，用于封装对数据库的访问，进行业务对象到数据库实体记录的转换
 *         3、convertor：数据转换器，用于将值对象之间转换。
 *         4、processor/handler: 代表处理某类功能的实例对象，实例有一组对应的行为
 *         5、manager: 代表管理某一系列实例对象的实例对象
 *         6、listener: 代表监听某类事件，并执行相应的处理逻辑。
 *         7、observer: 代表观察某类状态的实例对象
 *         8、strategy: 代表策略对象，提供一组算法，并封装，使得算法可以相互替换。
 *         9、validator: 代表数据校验对象，用于校验数据，并返回校验结果。
 *         10、executor: 代表执行器对象，执行某类任务。
 *         11、scheduler: 代表计划任务对象，执行某类任务。
 *         12、chain: 连锁对象，执行某类任务，并传递给下一个连锁。
 *         13、proxy: 代理对象，代理某类对象，对某类对象的行为进行代理。
 *     数据结构：
 *        1、value:表示值对象，没有唯一标识，无需管理生命周期，用于系统内部一对一的数据交换。
 *        2、entity:表示实体对象，有唯一标识，需要管理生命周期
 *        3、event:表示事件对象，有唯一追踪标识，存在生命周期，用于描述某类事件，并携带事件数据，用在系统内部对边界的访问
 *        4、signal:表示信号对象，无唯一追踪标识，不存在生命周期，用于描述某类信号，并携带信号数据，用在系统内部一对N的通知
 *        5、request：表示请求对象，专用于外部网络请求对边界的访问
 *        6、response：表示响应对象，专用于边界对外部网络请求的返回
 * 包名语义：
 *      1、endpoint:表示端点，是系统、模块的边界
 *      2、api:表示接口,端点的一种,是系统对外提供功能的入口
 *      3、values:表示值对象，存放数据结构
 *      4、inner:存放难以分类的内部文件
 *      5、entities：表示对应数据库记录的实体对象
 *      6、context:表示上下文对象，存放贯通系统层级的类
 * 系统业务术语：
 *     cdr:临床数据中心
 *      dataIntegration:数据集成,描述采集数据的业务。
 *      dataService:数据服务,描述数据中心对外提供数据的业务。
 *      indicator:指标，描述数据中心的指标业务。
 *      dataModel：模型设计，描述数据中心数据服务层的模型设计业务。
 *      dataDict: 数据字典
 *      maintenance: 运维中心，描述系统监控、作业调度、任务调度。
 *
 *
 *
 */
package com.ediagnosis.cdr;