package com.ediagnosis.cdr.dataIntegration.inner;

import com.ediagnosis.cdr.cache.CacheFacade;
import com.ediagnosis.cdr.dataIntegration.value.TableDefinitionItem;
import com.ediagnosis.cdr.dataIntegration.value.TableTree;
import org.springframework.stereotype.Component;

import java.util.List;
@Component
public class CacheableTableDefinitionRepository implements TableDefinitionRepository {
    private final DefaultTableDefinitionRepository defaultTableDefinitionRepository;

    private final CacheFacade cacheFacade;

    public CacheableTableDefinitionRepository(DefaultTableDefinitionRepository defaultTableDefinitionRepository,
                                              CacheFacade cacheFacade) {
        this.defaultTableDefinitionRepository = defaultTableDefinitionRepository;
        this.cacheFacade = cacheFacade;
    }

    @Override
    public TableTree getTableTree(String keyword) {

        cacheFacade.getCache(keyword, TableTree.class);

        defaultTableDefinitionRepository.getTableTree(keyword);

        return null;
    }

    @Override
    public List<TableDefinitionItem> getTableDefinitionItem(String tableId) {
        return List.of();
    }
}
