package com.ediagnosis.cdr.dataIntegration.inner;

import com.ediagnosis.cdr.dataIntegration.dao.BusinessDataDao;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BusinessDataSystemDTO;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BusinessDataSystemQueryDTO;
import com.ediagnosis.cdr.dataIntegration.dao.entity.BusinessDataSystem;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

/**
 * @author monojun
 * @description BusinessSystemRepository
 * @createTime 2025年08月05日
 */
@Repository
@RequiredArgsConstructor
public class BusinessSystemRepository {

    private final BusinessDataDao businessDataDao;

    /**
     * 新增业务系统
     *
     * @param dataSystemDTO 业务系统dto
     * @return 业务系统主键id
     */
    public Long addDataSystem(BusinessDataSystemDTO dataSystemDTO) {
        businessDataDao.addDataSystem(dataSystemDTO);
        return businessDataDao.addDataSystem(dataSystemDTO);
    }


    /**
     * 更新业务系统
     *
     * @param dataSystemDTO 业务系统dto
     * @return 业务系统主键id
     */
    public Long updateDataSystem(BusinessDataSystemDTO dataSystemDTO) {
        return businessDataDao.updateDataSystem(dataSystemDTO);
    }

    /**
     * 分页查询业务系统信息
     *
     * @param queryDTO 查询dto
     * @return PageInfo<BusinessDataSystem>
     */
    public Page<BusinessDataSystem> queryPage(BusinessDataSystemQueryDTO queryDTO) {
        return businessDataDao.querySystemPage(queryDTO);
    }

    /**
     * 删除业务系统
     *
     * @param dataSystemId 业务系统id
     */
    public void deleteDataSystem(Long dataSystemId) {
        businessDataDao.deleteDataSystem(dataSystemId);
    }

}
