package com.ediagnosis.cdr.dataIntegration.inner;


import com.ediagnosis.cdr.dataIntegration.dao.BusinessDataDao;
import com.ediagnosis.cdr.dataIntegration.dao.dto.*;
import com.ediagnosis.cdr.dataIntegration.dao.entity.BusinessDataSystem;
import com.ediagnosis.cdr.dataIntegration.dao.entity.BusinessDataTableField;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

/**
 * @author monojun
 * @description BusinessDataRepository
 * @createTime 2025年08月04日
 */
@Repository
@RequiredArgsConstructor
public class BusinessDataRepository {

    private final BusinessDataDao businessDataDao;

    /**
     * 分页查询业务系统信息
     *
     * @param queryDTO 查询dto
     * @return PageInfo<BusinessDataSystem>
     */
    public Page<BusinessDataSystem> queryPage(BusinessDataSystemQueryDTO queryDTO) {
        return businessDataDao.querySystemPage(queryDTO);
    }

    /**
     * 分页查询业务数据源信息
     *
     * @param queryDTO 查询dto
     * @return PageInfo<BusinessDataSource>
     */
    public Page<BusinessDataSourceDTO> querySourcePage(BusinessDataSourceQueryDTO queryDTO) {
        return businessDataDao.querySourcePage(queryDTO);
    }

    /**
     * 分页查询业务表信息
     *
     * @param queryDTO 查询dto
     * @return PageInfo<BusinessDataTable>
     */
    public Page<BusinessDataTableDTO> queryTablePage(BusinessDataTableQueryDTO queryDTO) {
        return businessDataDao.queryTablePage(queryDTO);
    }

    /**
     * 分页查询业务表字段信息
     *
     * @param queryDTO 查询dto
     * @return PageInfo<BusinessDataTableField>
     */
    public Page<BusinessDataTableField> queryFieldPage(BusinessDataTableFieldQueryDTO queryDTO) {
        return businessDataDao.queryFieldPage(queryDTO);
    }
}
