package com.ediagnosis.cdr.dataIntegration.dao.entity;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.Table;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;

/**
 * @author monojun
 * @description 业务系统数据源表
 * @createTime 2025年08月01日
 */
@Data
@Table(value = "business_data_source")
public class BusinessDataSource implements Serializable {
    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @Id(value = "id", keyType = KeyType.Auto)
    private Long id;

    /**
     * 数据源名称
     */
    @Column(value = "name")
    private String name;

    /**
     * 数据源类型
     */
    @Column(value = "type")
    private String type;

    /**
     * IP地址
     */
    @Column(value = "ip_address")
    private String ipAddress;

    /**
     * 属性信息
     */
    @Column(value = "properties")
    private String properties;

    /**
     * 业务系统id
     */
    @Column(value = "business_id")
    private Long businessId;

    /**
     * 描述
     */
    @Column(value = "description")
    private String description;

    /**
     * 连接状态: 0-未知 1-已连接 2-未连接
     */
    @Column(value = "status")
    private Integer status;

    /**
     * 创建时间
     */
    @Column(value = "create_time")
    private Date createTime;

    /**
     * 创建人
     */
    @Column(value = "create_user_id")
    private Long createUserId;

    /**
     * 更新时间
     */
    @Column(value = "update_time")
    private Date updateTime;

    /**
     * 更新人
     */
    @Column(value = "update_user_id")
    private Long updateUserId;

    /**
     * 是否删除: 0-未删除 1-已删除
     */
    @Column(value = "is_deleted", isLogicDelete = true)
    private Integer isDeleted;
}