package com.ediagnosis.cdr.dataIntegration;

import com.ediagnosis.cdr.dataIntegration.dao.dto.BusinessDataSystemDTO;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BusinessDataSystemQueryDTO;
import com.ediagnosis.cdr.dataIntegration.dao.entity.BusinessDataSystem;
import com.ediagnosis.cdr.dataIntegration.value.param.DataSystemAddParam;
import com.ediagnosis.cdr.dataIntegration.value.param.DataSystemDeleteParam;
import com.ediagnosis.cdr.dataIntegration.value.param.DataSystemQueryParam;
import com.ediagnosis.cdr.dataIntegration.value.param.DataSystemUpdateParam;
import com.ediagnosis.cdr.dataIntegration.value.BusinessDataSystemVo;
import com.ediagnosis.cdr.dataIntegration.inner.BusinessSystemRepository;
import com.ediagnosis.cdr.context.PageConvertUtils;
import com.ediagnosis.cdr.context.values.PageVo;
import com.ediagnosis.cdr.value.Response;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author monojun
 * @description 业务系统controller
 * @createTime 2025年08月04日
 */
@RestController
@RequestMapping("/bizSystem")
@RequiredArgsConstructor
public class BusinessSystemController {

    private final BusinessSystemRepository systemRepository;


    @PostMapping("/add")
    public Response<Long> page(@RequestBody DataSystemAddParam addParam) {
        BusinessDataSystemDTO addDTO = new BusinessDataSystemDTO();
        BeanUtils.copyProperties(addParam, addDTO);
        Long id = systemRepository.addDataSystem(addDTO);
        return Response.success(id);
    }

    @PostMapping("/update")
    public Response<Long> update(@RequestBody DataSystemUpdateParam updateParam) {
        BusinessDataSystemDTO addDTO = new BusinessDataSystemDTO();
        BeanUtils.copyProperties(updateParam, addDTO);
        Long id = systemRepository.updateDataSystem(addDTO);
        return Response.success(id);
    }


    @PostMapping("/page")
    public Response<PageVo<BusinessDataSystemVo>> page(@RequestBody DataSystemQueryParam queryParam) {
        BusinessDataSystemQueryDTO queryDTO = new BusinessDataSystemQueryDTO();
        BeanUtils.copyProperties(queryParam, queryDTO);
        Page<BusinessDataSystem> dataSystemPage = systemRepository.queryPage(queryDTO);
        PageVo<BusinessDataSystemVo> systemVoPageInfo = PageConvertUtils.copyPageInfo(dataSystemPage, dataSystem -> {
            BusinessDataSystemVo vo = new BusinessDataSystemVo();
            BeanUtils.copyProperties(dataSystem, vo);
            return vo;
        });
        return Response.success(systemVoPageInfo);
    }


    @PostMapping("/delete")
    public Response<Long> delete(@RequestBody DataSystemDeleteParam deleteParam) {
        systemRepository.deleteDataSystem(deleteParam.getId());
        return Response.success(deleteParam.getId());
    }


}
