package com.ediagnosis.cdr.context;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

import java.io.File;
import java.io.IOException;
import java.util.Optional;


public class JsonProcessor {

    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(JsonProcessor.class);


    public static <T> Optional<T> toObject(String json, Class<T> clazz) {
        T value;
        try {
            value = objectMapper.readValue(json, clazz);
        } catch (Exception e) {
            log.error("json to object error", e);
            return Optional.empty();
        }
        return Optional.ofNullable(value);
    }


    public static Optional<String> toJson(Object object) {
        String value;
        try {
            value = objectMapper.writeValueAsString(object);
        } catch (JsonProcessingException e) {
            log.error("object to json error", e);
            return Optional.empty();
        }
        return Optional.ofNullable(value);
    }

    public static void print(Object object) {
        toJson(object).ifPresent(System.out::println);
    }

    public static <T> Optional<T> readJsonFileToObject(String path, Class<T> clazz) {
        T value;
        if (path.startsWith("classpath:")) {
            path = path.substring("classpath:".length());
            ClassPathResource resource = new ClassPathResource(path);
            if (!resource.exists()) {
                log.error("classpath resource not exists: {}", path);
                return Optional.empty();
            }
            try {
                value = objectMapper.readValue(resource.getInputStream(), clazz);
            } catch (IOException e) {
                log.error("read json file error", e);
                return Optional.empty();
            }
            return Optional.ofNullable(value);
        }else {
            File file = new File(path);
            if (!file.exists()) {
                log.error("file not exists: {}", path);
                return Optional.empty();
            }

            try {
                value = objectMapper.readValue(file, clazz);
            } catch (IOException e) {
                log.error("read json file error", e);
                return Optional.empty();
            }
        }



        return Optional.ofNullable(value);
    }

}
