package com.ediagnosis.cdr.dataIntegration.value.param;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;

/**
 * @author monojun
 * @description 数据表新增参数
 * @createTime 2025年08月05日
 */
@Data
public class BizTableAddOrUpdateParam implements Serializable {
    @Serial
    private static final long serialVersionUID = 3378139727731995899L;

    /**
     * 主键id
     */
    private Integer id;

    /**
     * 业务表名称
     */
    @Column(value = "table_name")
    private String tableName;

    /**
     * 业务表编码
     */
    @Column(value = "table_code")
    private String tableCode;

    /**
     * 业务系统id
     */
    @Column(value = "biz_system_id")
    private Integer bizSystemId;

    /**
     * 业务数据源id
     */
    @Column(value = "biz_data_source_id")
    private Integer bizDataSourceId;

    /**
     * 描述
     */
    @Column(value = "description")
    private String description;
}
