package com.ediagnosis.cdr.dataIntegration.value.param;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;

/**
 * @author monojun
 * @description 数据源新增参数
 * @createTime 2025年08月05日
 */
@Data
public class BizSourceAddOrUpdateParam implements Serializable {
    @Serial
    private static final long serialVersionUID = 5282468723403441092L;

    /**
     * 主键id
     */
    private Integer id;

    /**
     * 数据源名称
     */
    @Column(value = "name")
    private String name;

    /**
     * 数据源类型
     */
    @Column(value = "type")
    private String type;

    /**
     * IP地址
     */
    @Column(value = "ip")
    private String ip;

    /**
     * 属性信息
     */
    @Column(value = "properties")
    private String properties;

    /**
     * 业务系统id
     */
    @Column(value = "biz_system_id")
    private Integer bizSystemId;

    /**
     * 描述
     */
    @Column(value = "description")
    private String description;
}
