package com.ediagnosis.cdr.dataIntegration.inner;

import com.ediagnosis.cdr.dataIntegration.dao.BizDataDao;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BizTableDTO;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BizTableQueryDTO;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author monojun
 * @description 数据表Repository
 * @createTime 2025年08月05日
 */
@Repository
@RequiredArgsConstructor
public class BizTableRepository {

    private final BizDataDao bizDataDao;

    /**
     * 新增or更新源业务表
     *
     * @param tableDTO 源业务表dto
     * @return 源业务表主键id
     */
    public Integer addOrUpdateDataTable(BizTableDTO tableDTO) {
        return bizDataDao.addOrUpdateDataTable(tableDTO);
    }


    /**
     * 分页查询源业务表信息
     *
     * @param queryDTO 查询dto
     * @return PageInfo<BizTableDTO>
     */
    public Page<BizTableDTO> queryPage(BizTableQueryDTO queryDTO) {
        return bizDataDao.queryTablePage(queryDTO);
    }

    /**
     * 删除源业务表
     *
     * @param dataTableIds 源数据表id
     */
    public void deleteDataSystem(List<Integer> dataTableIds) {
        bizDataDao.deleteBatchDataTable(dataTableIds);
    }
}
