package com.ediagnosis.cdr.dataIntegration.inner;

import com.ediagnosis.cdr.dataIntegration.dao.BizDataDao;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BizSystemDTO;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BizSystemQueryDTO;
import com.ediagnosis.cdr.dataIntegration.dao.entity.BizSystem;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author monojun
 * @description BizSystemRepository
 * @createTime 2025年08月05日
 */
@Repository
@RequiredArgsConstructor
public class BizSystemRepository {

    private final BizDataDao bizDataDao;

    /**
     * 新增or更新业务系统
     *
     * @param bizSystemDTO 业务系统dto
     * @return 业务系统主键id
     */
    public Integer addBizSystem(BizSystemDTO bizSystemDTO) {
        return bizDataDao.addOrUpdateBizSystem(bizSystemDTO);
    }


    /**
     * 分页查询业务系统信息
     *
     * @param queryDTO 查询dto
     * @return PageInfo<BizSystem>
     */
    public Page<BizSystem> queryPage(BizSystemQueryDTO queryDTO) {
        return bizDataDao.querySystemPage(queryDTO);
    }

    /**
     * 删除业务系统
     *
     * @param dataSystemIds 业务系统id列表
     */
    public void deleteDataSystem(List<Integer> dataSystemIds) {
        bizDataDao.deleteBatchBizSystem(dataSystemIds);
    }

}
