package com.ediagnosis.cdr.dataIntegration.inner;

import com.ediagnosis.cdr.dataIntegration.dao.BizDataDao;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BizDataSourceDTO;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BizDataSourceQueryDTO;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author monojun
 * @description 数据源Repository
 * @createTime 2025年08月05日
 */
@Repository
@RequiredArgsConstructor
public class BizSourceRepository {

    private final BizDataDao bizDataDao;

    /**
     * 新增or更新数据源
     *
     * @param dataSourceDTO 数据源dto
     * @return 数据源主键id
     */
    public Integer addDataSource(BizDataSourceDTO dataSourceDTO) {
        return bizDataDao.addOrUpdateDataSource(dataSourceDTO);
    }

    /**
     * 分页查询数据源信息
     *
     * @param queryDTO 查询dto
     * @return PageInfo<BizDataSourceDTO>
     */
    public Page<BizDataSourceDTO> queryPage(BizDataSourceQueryDTO queryDTO) {
        return bizDataDao.querySourcePage(queryDTO);
    }

    /**
     * 删除业务系统
     *
     * @param dataSourceIds 数据源id列表
     */
    public void deleteDataSource(List<Integer> dataSourceIds) {
        bizDataDao.deleteBatchDataSource(dataSourceIds);
    }
}
