package com.ediagnosis.cdr.dataIntegration.dao.entity;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.Table;
import lombok.Data;

import java.io.Serializable;

/**
 * @author monojun
 * @description 业务字段信息表
 * @createTime 2025年08月06日
 */
@Data
@Table(value = "biz_table_definition")
public class BizTableDefinition implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @Id(value = "id", keyType = KeyType.Auto)
    private Integer id;

    /**
     * 字段名称
     */
    @Column(value = "field_name")
    private String fieldName;

    /**
     * 字段类型
     */
    @Column(value = "field_type")
    private String fieldType;

    /**
     * 业务表id
     */
    @Column(value = "table_id")
    private Integer tableId;

    /**
     * 描述
     */
    @Column(value = "description")
    private String description;
}