package com.ediagnosis.cdr.dataIntegration.dao.dto;

import com.ediagnosis.cdr.dataIntegration.value.param.PageQuery;
import lombok.Data;

import java.io.Serial;
import java.util.List;

/**
 * @author monojun
 * @description 业务数据源查询dto
 * @createTime 2025年07月31日
 */
@Data
public class BizDataSourceQueryDTO extends PageQuery {
    @Serial
    private static final long serialVersionUID = 4373837873599613512L;

    /**
     * 业务系统id列表
     */
    private List<Integer> bizSystemIds;

    /**
     * 数据源名称
     */
    private String name;

    /**
     * ip地址
     */
    private String ip;

    /**
     * 数据源类型
     */
    private String type;

    /**
     * 连接状态: 0-未知 1-已连接 2-未连接
     */
    private Integer status;
}
