package com.ediagnosis.cdr.dataIntegration;

import com.ediagnosis.cdr.context.PageConvertUtils;
import com.ediagnosis.cdr.context.values.PageVo;

import com.ediagnosis.cdr.context.values.Response;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BizSystemDTO;
import com.ediagnosis.cdr.dataIntegration.dao.dto.BizSystemQueryDTO;
import com.ediagnosis.cdr.dataIntegration.dao.entity.BizSystem;
import com.ediagnosis.cdr.dataIntegration.inner.BizSystemRepository;
import com.ediagnosis.cdr.dataIntegration.value.BizSystemVo;
import com.ediagnosis.cdr.dataIntegration.value.param.BizSystemAddOrUpdateParam;
import com.ediagnosis.cdr.dataIntegration.value.param.BizSystemDeleteParam;
import com.ediagnosis.cdr.dataIntegration.value.param.BizSystemQueryParam;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author monojun
 * @description 业务系统
 * @createTime 2025年08月06日
 */
@RestController
@RequestMapping("/bizSystem")
@RequiredArgsConstructor
public class BizSystemController {

    private final BizSystemRepository systemRepository;

    @PostMapping("/addOrUpdate")
    public Response<Integer> addOrUpdate(@RequestBody BizSystemAddOrUpdateParam addOrUpdateParam) {
        BizSystemDTO addDTO = new BizSystemDTO();
        BeanUtils.copyProperties(addOrUpdateParam, addDTO);
        Integer id = systemRepository.addBizSystem(addDTO);
        return Response.success(id);
    }


    @PostMapping("/page")
    public Response<PageVo<BizSystemVo>> page(@RequestBody BizSystemQueryParam queryParam) {
        BizSystemQueryDTO queryDTO = new BizSystemQueryDTO();
        BeanUtils.copyProperties(queryParam, queryDTO);
        Page<BizSystem> dataSystemPage = systemRepository.queryPage(queryDTO);
        PageVo<BizSystemVo> systemVoPageInfo = PageConvertUtils.copyPageInfo(dataSystemPage, dataSystem -> {
            BizSystemVo vo = new BizSystemVo();
            BeanUtils.copyProperties(dataSystem, vo);
            return vo;
        });
        return Response.success(systemVoPageInfo);
    }


    @PostMapping("/delete")
    public Response<List<Integer>> delete(@RequestBody BizSystemDeleteParam deleteParam) {
        systemRepository.deleteDataSystem(deleteParam.getIds());
        return Response.success(deleteParam.getIds());
    }


}
