package com.ediagnosis.cdr.cache;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Optional;
//    todo: 待扩展，按需缓存策略进行缓存
@Component
public class CacheFacade {

    private static final Logger log = LoggerFactory.getLogger(CacheFacade.class);
    private final List<CacheExecutor> cacheExecutors;


    public CacheFacade(List<CacheExecutor> cacheExecutors) {
        this.cacheExecutors = cacheExecutors;
        CacheStrategyHolder.initCacheStrategy();
    }


    public <T> Optional<T> getCache(String key, Class<T> clazz) {
        if (cacheExecutors.isEmpty()) {
            log.warn("没有可用的缓存执行器");
            return Optional.empty();
        }


        for (CacheExecutor executor : cacheExecutors) {
            Optional<T> optional = executor.get(key, clazz);
            if (optional.isPresent()) {
                return optional;
            }
        }
        return Optional.empty();

    }

    public void putCache(String key, String value) {
        if (cacheExecutors.isEmpty()) {
            log.warn("没有可用的缓存执行器");
        }
        for (CacheExecutor executor : cacheExecutors) {
            executor.put(key, value);
        }
    }

}
