package com.ediagnosis.cdr.context;

import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.util.Assert;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;


@SpringBootTest
class TimeUtilTest {

    String time = "2021-01-01 00:00:00";
    String date = "2021-01-01";
    LocalDateTime localDateTime = LocalDateTime.of(2021, 1, 1, 0, 0, 0);
    LocalDate localDate = LocalDate.of(2021, 1, 1);

    @Test
    void toLocalDateTime() {
        Optional<LocalDateTime> timeOptional = TimeUtil.toLocalDateTime(time);
        Assert.isTrue(timeOptional.isPresent(), "时间不存在");
        Assert.isTrue(localDateTime.equals(timeOptional.get()), "时间不相等");
    }

    @Test
    void testToString() {
        Optional<String> timeOptional = TimeUtil.toString(localDateTime);
        Assert.isTrue(timeOptional.isPresent(), "时间不存在");
        Assert.isTrue(time.equals(timeOptional.get()), "时间字符串不相等");
    }

    @Test
    void toLocalDate() {
        Optional<LocalDate> timeOptional = TimeUtil.toLocalDate(date);
        Assert.isTrue(timeOptional.isPresent(), "时间不存在");
        Assert.isTrue(localDate.equals(timeOptional.get()), "时间不相等");
    }

    @Test
    void testDateToString() {
        Optional<String> timeOptional = TimeUtil.toString(localDate);
        Assert.isTrue(timeOptional.isPresent(), "时间不存在");
        Assert.isTrue(date.equals(timeOptional.get()), "时间字符串不相等");
    }
}