package com.ediagnosis.cdr.context;

import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.springframework.boot.test.context.SpringBootTest;

import java.util.List;

import static org.mockito.Mockito.*;

@SpringBootTest
public class MockTest {
    @Test
    public void testBasicVerification() {
        List<String> mockList = mock(List.class);

        // 模拟调用
        mockList.add("apple");
        mockList.add("banana");
        mockList.add("apple");


        // 1. 验证方法被调用【恰好一次】（默认行为）
        verify(mockList).add("banana");

        // 2. 验证方法被调用【指定次数】
        verify(mockList, times(2)).add("apple");  // 精确2次

        // 3. 验证方法【从未调用】
        verify(mockList, never()).clear();

        // 4. 验证【调用顺序】
        InOrder inOrder = inOrder(mockList);
        inOrder.verify(mockList).add("apple");
        inOrder.verify(mockList).add("banana");
        inOrder.verify(mockList).add("apple");

        verifyNoMoreInteractions(mockList);
    }
}
