package com.ediagnosis.cdr.util;

import com.ediagnosis.cdr.value.PageVo;
import com.mybatisflex.core.paginate.Page;
import org.springframework.beans.BeanUtils;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author monojun
 * @description 拷贝工具
 * @createTime 2025年07月03日
 */
public class PageConvertUtils {
    /**
     * 拷贝 Page<T> 到 PageVo<R>
     *
     * @param source   原始分页数据
     * @param function 转换函数 T -> R
     * @param <T>      源类型
     * @param <R>      目标类型
     * @return PageInfo<R>
     */
    public static <T, R> PageVo<R> copyPageInfo(Page<T> source, Function<T, R> function) {
        PageVo<R> result = new PageVo<>();
        // 拷贝分页信息（排除list）
        BeanUtils.copyProperties(source, result, "list");
        result.setPageNo(source.getPageNumber());
        result.setPageSize(source.getPageSize());
        result.setTotalCount(source.getTotalRow());
        result.setTotalPage(source.getTotalPage());
        List<R> collect = source.getRecords().stream()
                .map(function)
                .collect(Collectors.toList());
        result.setContent(collect);
        return result;
    }


}
