package com.ediagnosis.cdr.dataCollect;


import com.ediagnosis.cdr.dataCollect.dao.dto.*;
import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataTableField;
import com.ediagnosis.cdr.dataCollect.endpoint.param.DataSourceQueryParam;
import com.ediagnosis.cdr.dataCollect.endpoint.param.DataTableFieldQueryParam;
import com.ediagnosis.cdr.dataCollect.endpoint.param.DataTableQueryParam;
import com.ediagnosis.cdr.dataCollect.endpoint.vo.BusinessDataSourceVo;
import com.ediagnosis.cdr.dataCollect.endpoint.vo.BusinessDataTableFieldVo;
import com.ediagnosis.cdr.dataCollect.endpoint.vo.BusinessDataTableVo;
import com.ediagnosis.cdr.dataCollect.inner.BusinessDataRepository;
import com.ediagnosis.cdr.util.PageConvertUtils;
import com.ediagnosis.cdr.value.PageVo;
import com.ediagnosis.cdr.value.Response;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author monojun
 * @description 业务系统controller
 * @createTime 2025年08月04日
 */
@RestController
@RequiredArgsConstructor
public class BusinessDataController {

    private final BusinessDataRepository dataRepository;


    @PostMapping("/dataSource/page")
    public Response<PageVo<BusinessDataSourceVo>> page(@RequestBody DataSourceQueryParam queryParam) {
        BusinessDataSourceQueryDTO queryDTO = new BusinessDataSourceQueryDTO();
        BeanUtils.copyProperties(queryParam, queryDTO);
        Page<BusinessDataSourceDTO> dataSourcePage = dataRepository.querySourcePage(queryDTO);
        PageVo<BusinessDataSourceVo> systemVoPageInfo = PageConvertUtils.copyPageInfo(dataSourcePage, dataSourceDTO -> {
            BusinessDataSourceVo vo = new BusinessDataSourceVo();
            BeanUtils.copyProperties(dataSourceDTO, vo);
            vo.setBizSystemId(dataSourceDTO.getBusinessId());
            vo.setBizSystemName(dataSourceDTO.getBusinessName());
            return vo;
        });
        return Response.success(systemVoPageInfo);
    }

    @PostMapping("/dataTable/page")
    public Response<PageVo<BusinessDataTableVo>> page(@RequestBody DataTableQueryParam queryParam) {
        BusinessDataTableQueryDTO queryDTO = new BusinessDataTableQueryDTO();
        BeanUtils.copyProperties(queryParam, queryDTO);
        Page<BusinessDataTableDTO> dataTablePage = dataRepository.queryTablePage(queryDTO);
        PageVo<BusinessDataTableVo> dataTableVoPageInfo = PageConvertUtils.copyPageInfo(dataTablePage, dataTable -> {
            BusinessDataTableVo vo = new BusinessDataTableVo();
            BeanUtils.copyProperties(dataTable, vo);
            return vo;
        });
        return Response.success(dataTableVoPageInfo);
    }

    @PostMapping("/dataTableField/page")
    public Response<PageVo<BusinessDataTableFieldVo>> page(@RequestBody DataTableFieldQueryParam queryParam) {
        BusinessDataTableFieldQueryDTO queryDTO = new BusinessDataTableFieldQueryDTO();
        BeanUtils.copyProperties(queryParam, queryDTO);
        Page<BusinessDataTableField> dataTableFieldPage = dataRepository.queryFieldPage(queryDTO);
        PageVo<BusinessDataTableFieldVo> tableFieldVoPageInfo = PageConvertUtils.copyPageInfo(dataTableFieldPage, dataTableField -> {
            BusinessDataTableFieldVo vo = new BusinessDataTableFieldVo();
            BeanUtils.copyProperties(dataTableField, vo);
            return vo;
        });
        return Response.success(tableFieldVoPageInfo);
    }


}
