package com.ediagnosis.cdr.util;


import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.util.Assert;

import java.util.Optional;


@SpringBootTest
class JsonProcessorTest {


   private static final Person person=new Person("张三",18);

    @Test
    void toObject() {
        String json = "{\"name\":\"张三\",\"age\":18}";
        Optional<Person> personOptional = JsonProcessor.toObject(json, Person.class);
        Assert.isTrue(personOptional.isPresent(), "转换结果不应为空");
        Person tmpPerson = personOptional.get();
        Assert.isTrue(person.equals(tmpPerson), "转换后的对象与预期不一致");
    }

    @Test
    void toJson() {
        Optional<String> json = JsonProcessor.toJson(person);
        Assert.isTrue(json.isPresent(), "转换结果不应为空");
        Assert.isTrue(json.get().equals("{\"name\":\"张三\",\"age\":18}"), "转换结果与预期不一致");

    }
}