package com.ediagnosis.cdr.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Optional;


public class JsonProcessor {

    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(JsonProcessor.class);


    public static <T> Optional<T> toObject(String json, Class<T> clazz) {
        T value = null;
        try {
            value = objectMapper.readValue(json, clazz);
        } catch (Exception e) {
            log.error("json to object error", e);
        }
        return Optional.ofNullable(value);
    }


    public static Optional<String> toJson(Object object) {
        String value = "";
        try {
            value = objectMapper.writeValueAsString(object);
        } catch (JsonProcessingException e) {
            log.error("object to json error", e);

        }
        return Optional.ofNullable(value);
    }
}
