package com.ediagnosis.cdr.dao;

import com.ediagnosis.cdr.dao.entity.DimDataSummaryEntity;
import com.ediagnosis.cdr.dao.mapper.DimDataSummaryMapper;
import com.ediagnosis.cdr.domain.DimDataSummary;
import com.ediagnosis.cdr.util.TimeUtil;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;

@Repository
public class DimDataSummaryRepository {

    private final DimDataSummaryMapper dimDataSummaryMapper;

    public DimDataSummaryRepository(DimDataSummaryMapper dimDataSummaryMapper) {
        this.dimDataSummaryMapper = dimDataSummaryMapper;
    }

    public List<DimDataSummary> getAllDimDataSummary() {
        List<DimDataSummaryEntity> entityList = dimDataSummaryMapper.selectAll();
        return entityList.stream().map(this::convertToDimDataSummary).toList();
    }


    private DimDataSummary convertToDimDataSummary(DimDataSummaryEntity entity) {
        Optional<LocalDateTime> timeOptional = TimeUtil.toLocalDateTime(entity.getUpdateTime());

        return new DimDataSummary(
                entity.getName(),
                entity.getCode(),
                entity.getValue(),
                timeOptional.orElse(null)
        );
    }


}
