package com.ediagnosis.cdr.dao;

import com.ediagnosis.cdr.CdrApplication;
import com.ediagnosis.cdr.dataCollect.dao.BusinessDataDao;
import com.ediagnosis.cdr.dataCollect.dao.dto.BusinessDataSourceDTO;
import com.ediagnosis.cdr.dataCollect.dao.dto.BusinessDataSourceQueryDTO;
import com.ediagnosis.cdr.dataCollect.dao.dto.BusinessDataTableDTO;
import com.ediagnosis.cdr.dataCollect.dao.dto.BusinessDataTableQueryDTO;
import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataSource;
import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataSystem;
import com.ediagnosis.cdr.dataCollect.dao.mapper.BusinessDataSourceMapper;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryWrapper;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author monojun
 * @description MapperTest
 * @createTime 2025年07月31日
 */
@SpringBootTest(classes = CdrApplication.class)
public class MapperTest {

    @Autowired
    private BusinessDataSourceMapper dataSourceMapper;

    @Autowired
    private BusinessDataDao businessDataDao;

    @Test
    public void test1() {
        BusinessDataSourceQueryDTO queryDTO = new BusinessDataSourceQueryDTO();
        QueryWrapper queryWrapper = QueryWrapper.create()
                .select("d.*, ds.name as businessName")
                .from("business_data_source").as("d")
                .leftJoin("business_data_system").as("ds")
                .on("d.business_id = ds.id");
        Page<BusinessDataSourceDTO> dataSourceDTOPage = dataSourceMapper.paginateAs(1, 10, queryWrapper, BusinessDataSourceDTO.class);
        System.out.println(dataSourceDTOPage);
    }

    @Test
    public void test2() {
        QueryWrapper queryWrapper = QueryWrapper.create()
                .select("d.*", "ds.id as businessId, ds.name as businessName")
                .from(BusinessDataSource.class).as("d")
                .leftJoin(BusinessDataSystem.class).as("ds")
                .on(BusinessDataSource::getBusinessId, BusinessDataSystem::getId);
        queryWrapper.in(BusinessDataSource::getBusinessId, 1);

        Page<BusinessDataSourceDTO> dataSourceDTOPage = dataSourceMapper.paginateAs(1, 10, queryWrapper, BusinessDataSourceDTO.class);
        System.out.println(dataSourceDTOPage);
    }

    @Test
    public void test3() {
        BusinessDataTableQueryDTO queryDTO = new BusinessDataTableQueryDTO();
        List<Long> businessIds = Arrays.asList(1L, 2L, 3L);
        queryDTO.setBusinessIds(businessIds);
        Page<BusinessDataTableDTO> businessDataTableDTOPage = businessDataDao.queryTablePage(queryDTO);
        System.out.println(businessDataTableDTOPage);

        BusinessDataTableQueryDTO query1DTO = new BusinessDataTableQueryDTO();
        List<Long> list = Stream.of(1L, 2L, 3L).collect(Collectors.toList());
        query1DTO.setSourceIds(list);
        Page<BusinessDataTableDTO> businessDataTableDTOPage1 = businessDataDao.queryTablePage(query1DTO);
        System.out.println(businessDataTableDTOPage1);
    }


}
