package com.ediagnosis.cdr.dataCollect.inner;

import com.ediagnosis.cdr.dataCollect.dao.BusinessDataDao;
import com.ediagnosis.cdr.dataCollect.dao.dto.BusinessDataSourceDTO;
import com.ediagnosis.cdr.dataCollect.dao.dto.BusinessDataSourceQueryDTO;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

/**
 * @author monojun
 * @description 数据源Repository
 * @createTime 2025年08月05日
 */
@Repository
@RequiredArgsConstructor
public class BusinessSourceRepository {

    private final BusinessDataDao businessDataDao;

    /**
     * 新增数据源
     *
     * @param dataSourceDTO 数据源dto
     * @return 数据源主键id
     */
    public Long addDataSource(BusinessDataSourceDTO dataSourceDTO) {
        return businessDataDao.addDataSource(dataSourceDTO);
    }


    /**
     * 更新数据源
     *
     * @param dataSourceDTO 业务系统dto
     * @return 数据源主键id
     */
    public Long updateDataSource(BusinessDataSourceDTO dataSourceDTO) {
        return businessDataDao.updateDataSource(dataSourceDTO);
    }

    /**
     * 分页查询数据源信息
     *
     * @param queryDTO 查询dto
     * @return PageInfo<BusinessDataSystem>
     */
    public Page<BusinessDataSourceDTO> queryPage(BusinessDataSourceQueryDTO queryDTO) {
        return businessDataDao.querySourcePage(queryDTO);
    }

    /**
     * 删除业务系统
     *
     * @param dataSourceId 数据源id
     */
    public void deleteDataSource(Long dataSourceId) {
        businessDataDao.deleteDataSource(dataSourceId);
    }
}
