package com.ediagnosis.cdr.dataCollect.dao.entity;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.Table;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;

/**
 * @author monojun
 * @description 业务表信息表
 * @createTime 2025年08月01日
 */
@Data
@Table(value = "business_data_table")
public class BusinessDataTable implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @Id(value = "id", keyType = KeyType.Auto)
    private Long id;

    /**
     * 业务表名称
     */
    @Column(value = "name")
    private String name;

    /**
     * 业务表编号
     */
    @Column(value = "table_no")
    private String tableNo;

    /**
     * 业务系统id
     */
    @Column(value = "business_id")
    private Long businessId;

    /**
     * 业务数据源id
     */
    @Column(value = "source_id")
    private Long sourceId;

    /**
     * 描述
     */
    @Column(value = "description")
    private String description;

    /**
     * 创建时间
     */
    @Column(value = "create_time")
    private Date createTime;

    /**
     * 创建人
     */
    @Column(value = "create_user_id")
    private Long createUserId;

    /**
     * 更新时间
     */
    @Column(value = "update_time")
    private Date updateTime;

    /**
     * 更新人
     */
    @Column(value = "update_user_id")
    private Long updateUserId;

    /**
     * 是否删除: 0-未删除 1-已删除
     */
    @Column(value = "is_deleted")
    private Byte isDeleted;
}