package com.ediagnosis.cdr.dataCollect;

import com.ediagnosis.cdr.dataCollect.dao.dto.BusinessDataSourceDTO;
import com.ediagnosis.cdr.dataCollect.dao.dto.BusinessDataSourceQueryDTO;
import com.ediagnosis.cdr.dataCollect.endpoint.param.DataSourceAddParam;
import com.ediagnosis.cdr.dataCollect.endpoint.param.DataSourceDeleteParam;
import com.ediagnosis.cdr.dataCollect.endpoint.param.DataSourceQueryParam;
import com.ediagnosis.cdr.dataCollect.endpoint.param.DataSourceUpdateParam;
import com.ediagnosis.cdr.dataCollect.endpoint.vo.BusinessDataSourceVo;
import com.ediagnosis.cdr.dataCollect.inner.BusinessSourceRepository;
import com.ediagnosis.cdr.util.PageConvertUtils;
import com.ediagnosis.cdr.value.PageVo;
import com.ediagnosis.cdr.value.Response;
import com.mybatisflex.core.paginate.Page;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author monojun
 * @description 数据源controller
 * @createTime 2025年08月05日
 */
@RestController
@RequestMapping("/dataSource")
@RequiredArgsConstructor
public class BusinessSourceController {

    private final BusinessSourceRepository sourceRepository;


    @PostMapping("/add")
    public Response<Long> page(@RequestBody DataSourceAddParam addParam) {
        BusinessDataSourceDTO addDTO = new BusinessDataSourceDTO();
        BeanUtils.copyProperties(addParam, addDTO);
        Long id = sourceRepository.addDataSource(addDTO);
        return Response.success(id);
    }

    @PostMapping("/update")
    public Response<Long> update(@RequestBody DataSourceUpdateParam updateParam) {
        BusinessDataSourceDTO updateDTO = new BusinessDataSourceDTO();
        BeanUtils.copyProperties(updateParam, updateDTO);
        Long id = sourceRepository.updateDataSource(updateDTO);
        return Response.success(id);
    }


    @PostMapping("/page")
    public Response<PageVo<BusinessDataSourceVo>> page(@RequestBody DataSourceQueryParam queryParam) {
        BusinessDataSourceQueryDTO queryDTO = new BusinessDataSourceQueryDTO();
        BeanUtils.copyProperties(queryParam, queryDTO);
        Page<BusinessDataSourceDTO> dataSourcePage = sourceRepository.queryPage(queryDTO);
        PageVo<BusinessDataSourceVo> systemVoPageInfo = PageConvertUtils.copyPageInfo(dataSourcePage, dataSource -> {
            BusinessDataSourceVo vo = new BusinessDataSourceVo();
            BeanUtils.copyProperties(dataSource, vo);
            return vo;
        });
        return Response.success(systemVoPageInfo);
    }


    @PostMapping("/delete")
    public Response<Long> delete(@RequestBody DataSourceDeleteParam deleteParam) {
        sourceRepository.deleteDataSource(deleteParam.getId());
        return Response.success(deleteParam.getId());
    }

}
