package com.ediagnosis.cdr.service;


import com.mybatisflex.core.datasource.DataSourceKey;
import com.mybatisflex.core.row.Db;
import com.mybatisflex.core.row.Row;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;

import java.util.List;

@SpringBootTest
class HiveServiceTest {


    @Test
    public void selectPage() {
        String sql = "SELECT * FROM ods.xjd_patient_info ORDER BY id LIMIT 10";
        try {
            DataSourceKey.use("ds-hive");
            List<Row> rows = Db.selectListBySql(sql);
            System.out.println(rows);
        } finally {
            DataSourceKey.clear();
        }
    }

    @Test
    public void insertTest() {

        String sql = "INSERT INTO TABLE ods.test1(id) VALUES (?)";
        try {
            DataSourceKey.use("ds-hive");
            int rows = Db.insertBySql(sql,2);
            System.out.println(rows);
        } finally {
            DataSourceKey.clear();
        }
    }


}