package com.ediagnosis.cdr.vo;

import java.util.List;

public class Page<T> {
    private int pageNo;
    private int pageSize;
    private int totalCount;
    private List<T> content;
    private int totalPage;

    public Page() {
    }

    public Page(int pageNo, int pageSize,
                int totalCount, List<T> content) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.totalCount = totalCount;
        this.content = content;
        int tmp=totalCount / pageSize;
        int tmp1=totalCount % pageSize;
        if (tmp1>0) {
            this.totalPage = tmp+1;
        }else {
            this.totalPage = tmp;
        }

    }


    public int getPageNo() {
        return pageNo;
    }


    public int getPageSize() {
        return pageSize;
    }


    public int getTotalCount() {
        return totalCount;
    }


    public int getTotalPage() {
        return totalPage;
    }


    public List<T> getContent() {
        return content;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public void setContent(List<T> content) {
        this.content = content;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }


}
