package com.ediagnosis.cdr.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.stereotype.Component;

@Component
public class JsonProcessor {

    private final ObjectMapper objectMapper;

    public JsonProcessor(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }


    public <T>T toObject(String json, Class<T> clazz) {
        try {
            return objectMapper.readValue(json, clazz);
        } catch (Exception e) {
//            todo:打印日志
            throw new RuntimeException(e);
        }
    }


    public String toJson(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        } catch (JsonProcessingException e) {
//            todo:打印日志
            throw new RuntimeException(e);
        }
    }
}
