package com.ediagnosis.cdr.dataGovernance;

import com.mybatisflex.core.datasource.DataSourceKey;
import com.mybatisflex.core.row.Db;
import com.mybatisflex.core.row.Row;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;

import java.util.ArrayList;
import java.util.List;

@SpringBootTest
public class TableDefinitionTest {

    @Test
    public void testPresto() {
        try{
            DataSourceKey.use("ds-presto");
            String sql = "select count(*) from hive.ods.xjd_patient_info";
            List<Row> rows = Db.selectListBySql(sql);
            System.out.println(rows.size());
            System.out.println(rows);
        }finally{
            DataSourceKey.clear();
        }
    }


    @Test
    public void testTableDefinition() {
        List<Row> rows=null;
        try{
            DataSourceKey.use("ds-presto");
            String sql = "DESCRIBE hive.ods.xjd_patient_info";
            rows = Db.selectListBySql(sql);
        }finally{
            DataSourceKey.clear();
        }
        List<TestTableDefinitionItem> items = new ArrayList<>(rows.size());
        for (Row row : rows) {
            TestTableDefinitionItem item = new TestTableDefinitionItem();
            item.setColumn(row.getString("Column"));
            item.setType(row.getString("Type"));
            item.setComment(row.getString("Comment"));
            System.out.println(item);
            items.add(item);
        }
        System.out.println(rows.size());
        System.out.println(items.size());


    }
}
