package com.ediagnosis.cdr.dataGovernance.value;

import java.util.LinkedList;
import java.util.List;

public class TableTree {



    public static class TreeNode {
        private final String id;
        private final String code;
        private final List<TreeNode> children = new LinkedList<>();
        private final boolean tableNodeFlag;

        public TreeNode(String id, String code, boolean tableNodeFlag) {
            this.id = id;
            this.code = code;
            this.tableNodeFlag = tableNodeFlag;
        }

        public TreeNode appendChild(String id, String code,boolean tableNodeFlag) {
            TreeNode node = new TreeNode(id,code,tableNodeFlag);
            this.children.add(node);
            return node;
        }


        public String getId() {
            return id;
        }

        public String getCode() {
            return code;
        }

        public boolean isTableNodeFlag() {
            return tableNodeFlag;
        }

        public List<TreeNode> getChildren() {
            return children;
        }
    }


    private List<TreeNode> rootNodes;

    public static TableTree create() {
        TableTree tableTree = new TableTree();
        tableTree.rootNodes = new LinkedList<>();
        return tableTree;
    }

    public TableTree ofRoot(TreeNode... node) {
        rootNodes.addAll(List.of(node));
        return this;
    }

    public TableTree ofChild(TreeNode parent, TreeNode... childNode) {
        parent.children.addAll(List.of(childNode));
        return this;
    }

    public TreeNode addRoot(TreeNode node) {
        rootNodes.add(node);
        return node;
    }

    public List<TreeNode> getRootNodes() {
        return rootNodes;
    }

    public void setRootNodes(List<TreeNode> rootNodes) {
        this.rootNodes = rootNodes;
    }
}
