package com.ediagnosis.cdr.demo;

import com.alibaba.fastjson.JSON;
import com.ediagnosis.cdr.CdrApplication;
import com.ediagnosis.cdr.dataCollect.dao.entity.BusinessDataSystem;
import com.ediagnosis.cdr.model.dto.BusinessDataSystemDTO;
import com.ediagnosis.cdr.model.dto.BusinessDataSystemQueryDTO;
import com.ediagnosis.cdr.model.dto.BusinessDataTableDTO;
import com.ediagnosis.cdr.model.dto.BusinessDataTableQueryDTO;
import com.ediagnosis.cdr.service.BusinessDataSystemService;
import com.ediagnosis.cdr.service.BusinessDataTableService;
import com.mybatisflex.core.paginate.Page;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

/**
 * @author monojun
 * @description ServiceTest
 * @createTime 2025年07月31日
 */
@SpringBootTest(classes = CdrApplication.class)
public class DemoTest {

    @Autowired
    private BusinessDataTableService tableService;

    @Autowired
    private BusinessDataSystemService dataSystemService;

    @Test
    public void test1() {
        BusinessDataTableQueryDTO queryDTO = new BusinessDataTableQueryDTO();
        Page<BusinessDataTableDTO> businessDataTableDTOPage = tableService.queryPage(queryDTO);
        System.out.println(JSON.toJSONString(businessDataTableDTOPage));
    }

    @Test
    public void test2() {
        BusinessDataSystemQueryDTO queryDTO = new BusinessDataSystemQueryDTO();
        Page<BusinessDataSystem> dataSystemPage = dataSystemService.queryPage(queryDTO);
        System.out.println(JSON.toJSONString(dataSystemPage));
    }

    @Test
    public void test3() {
        BusinessDataSystemDTO dataSystemDTO = new BusinessDataSystemDTO();
        dataSystemDTO.setName("业务系统demo3");
        dataSystemDTO.setDescription("业务系统demo3描述");
        Long l = dataSystemService.addDataSystem(dataSystemDTO);
        System.out.println(l);
        BusinessDataSystemDTO updateDataSystemDTO = new BusinessDataSystemDTO();
        updateDataSystemDTO.setId(l);
        updateDataSystemDTO.setDescription("业务系统demo3描述1");
        dataSystemService.updateDataSystem(updateDataSystemDTO);
    }


}
